# -*- coding: utf-8 -*-
"""
Created on Mon Aug  9 17:05:24 2021

@author: koenv
"""

import os
os.chdir(r'C:\Users\koenv\OneDrive - WageningenUR\PHD onedrive\4. Papers\3 effluents fractionation\data\MP scatter')
os.getcwd()

import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
from scipy import stats
import matplotlib

fn1 = 'MP av.xlsx'
fn2 = 'errorbars.xlsx'
fn3 = 'Ozone doses.xlsx'
xl = pd.ExcelFile(fn1)
sns = xl.sheet_names
colors = ['#e41a1c','#377eb8','#4daf4a','#984ea3','#ff7f00','#ffff33']
markers = ["o", "v", "^", "<", ">", "s"]
matplotlib.rcParams.update({'font.size': 20})
matplotlib.rc('xtick', labelsize=15) 
matplotlib.rc('ytick', labelsize=15)

######################################## use from scipy.optimize import curve_fit? popt, pcov = curve_fit(func, x, y,p0, method='dogbox',maxfev=10000)
 
# read data
for p in range(len(sns)):
    avdata = pd.read_excel(fn1, sheet_name=sns[p], header=[0,1], index_col=[0,1])
    erdata = pd.read_excel(fn2, sheet_name=sns[p], header=[0,1], index_col=[0,1])
    dosedata = pd.read_excel(fn3, sheet_name=sns[p], header=[0,1], index_col=[0]) 
# set keys      
    data = pd.read_excel(fn1, sheet_name=sns[p], header=[0,1], index_col=[0,1])
    headers = list(data.columns)
    fractions = []
    doses = []
    for i in headers:
        if i[0] not in fractions:
            fractions += [i[0]]
        if i[1] not in doses:
            doses += [i[1]]           
    effluents = []
    groups = []
    indexes = list(data.index)  
    for i in indexes:
        if i[0] not in effluents:
            effluents += [i[0]]
        if i[1] not in groups:
            groups += [i[1]]  
# make plot
    fig, axs = plt.subplots(1,len(groups))
    for m in range(len(groups)):
        for i in range(len(fractions)):
            av = []
            er = []
            dose = []
            for j in range(len(doses)):
                for n in range(len(effluents)):
                    av += [avdata[fractions[i]][doses[j]][effluents[n]][groups[m]]]
                    er += [erdata[fractions[i]][doses[j]][effluents[n]][groups[m]]]
                    dose += [dosedata[fractions[i]][doses[j]][effluents[n]]]

#            axs[m].errorbar(x=dose, y=av, label=fractions[i], yerr=er, color=colors[i], lw=1,capsize=1)   #wrong colors in legend
            axs[m].scatter(dose, av, color=colors[i], marker=markers[i])
# add regressions  
#            axs[m].scatter(dose, av, s=20, label=fractions[i], color=colors[i], marker=markers[i])  #facecolors='none', edgecolors=colors[i],
#            r1 = stats.linregress(np.log(dose), av) #log regression
#            xf = np.linspace(0,max(dose),100)
#            axs[m].plot(xf, r1.slope*np.log(xf)+r1.intercept, ':', color=colors[i])

              
#plot layout    , color=colors[n]              
            axs[m].set_xlim([0,1])
            axs[m].set_ylim([0,100])  
            axs[m].set_title(groups[m])
    for ax in axs.flat:
        ax.label_outer()
    if p==2:
        plt.legend(fractions, loc=(1.05,0))
    else:plt.legend(fractions, loc=(1.05,0.2))
    fig.add_subplot(111, frameon=False)
    plt.tick_params(labelcolor='none', which='both', top=False, bottom=False, left=False, right=False)
    plt.xlabel('Ozone dose (g O3/g C)')
    plt.ylabel('MP removal (%)')
    


#save    
    fig.set_size_inches(10, 3)
    fignname = str(sns[p]) + ' MP scatter.jpg'
    fig.savefig(fignname, bbox_inches='tight')       
"""

 
    
"""